/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __VARIABLE_CPP
#define __VARIABLE_CPP

#include "variable.h"

Variable::Variable(const char* _name, double _value)
{
	name = _name;
	value = _value;
	context = NULL;
}

Variable::Variable(const char* _name, double _value, SpatialContext* _context)
{
	name = _name;
	value = _value;
	context = _context;
}

Variable::~Variable()
{
}

void Variable::report(ostream& strm) const
{
	strm<<"Variable(name="<<name<<" value="<<value<<"->";
	if(context != NULL) 
		context->report(strm);
	else
		strm<<"SpatialContext is NULL";
	strm<<"\n";
}

#endif