/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __OUTPUTWRITER_H
#define __OUTPUTWRITER_H

#include <iostream>
#include <fstream>

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class FocusRegistry;
class FocusException;

class OutputWriter
{
private:
	FocusRegistry*	registry;
	char*			base_name;
	char*			raw_stats_file_name;
	char*			aggr_stats_file_name;
	char*			plot_file_name;
	
	bool			write_aggr_header;
	bool			write_stats_header;
	bool			time_stamp;
	bool			write_statistics;
	bool			write_plots;

	ofstream*		raw_stats_stream;
	ofstream*		aggr_stats_stream;
	ofstream*		plot_stream;

public:
	OutputWriter(FocusRegistry* _registry, char* _base_name, bool _time_stamp, bool _write_plots, bool _write_stats);
	~OutputWriter();

	void setBaseName(char* _base_name)			{ base_name = _base_name; };
	char* getBaseName() const					{ return base_name; };
	
	void init_outputfile_names();
	void init_output_streams()throw (FocusException);
	void close_output_streams();
	
	void write_plot_data();
	void write_raw_statistics(int _run);
	void write_aggregated_statistics();
	void write_outputfile_names(ostream& strm=cout);

private:
	void write_iteration(int _run, ostream& strm=cout);
	void write_constraint(ostream& strm=cout);
	void write_regression(ostream& strm=cout);
	void write_anova(ostream& strm=cout);
	void write_plot_ids(ostream& strm=cout);
	void write_duplicate(ostream& strm=cout);
	void write_unique(ostream& strm=cout);

	void write_iteration_header(ostream& strm=cout);
	void write_constraint_header(ostream& strm=cout);
	void write_regression_header(ostream& strm=cout);
	void write_anova_header(ostream& strm=cout);
	void write_duplicate_header(ostream& strm=cout);
	void write_unique_header(ostream& strm=cout);
	void write_plot_header(ostream& strm=cout);

	void confirmFileName(char* _filename) throw (FocusException);
};

#endif