/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __OBSERVER_H
#define __OBSERVER_H

//number of statisic variables to be calculated after observation
#define STATSVAR 6

//list or layer positions for the statistical parameters
#define MEAN 0
#define MIN 1
#define MAX 2
#define VAR 3
#define CONFID 4
#define STDERR 5

#include <iostream>
#include "dfarr.h"
#include "diarr.h"

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class FocusRegistry;

//VIRTUAL BASE CLASS FOR ALL OBSERVERS

class Observer
{
protected:
	const char*    	name;			//observer name
	unsigned short	runs;         	//number of iterations for one constraint
	bool 			stats;			//flag, indicates whether statistics are calculated or not

	
	FocusRegistry*	registry;	
	
public:
	Observer() {};
	Observer(FocusRegistry* _registry, const char* _name, unsigned short _runs);
	~Observer();
	virtual void reset() {};
	virtual void init() {};

	const char* getName() const							{ return name; };

	void setRuns(unsigned short _runs)					{ runs = _runs; };
	unsigned short getRuns() const						{ return runs; };

	bool operator == (const Observer& _observer) const;
	bool operator != (const Observer& _observer) const;
   
	virtual void observe(int _run) {};
	virtual void calc_stats() {};

	virtual void report_variable_names(ostream& strm=cout) const {};
	virtual void report(ostream& strm=cout) const {};
};

class AnovaObserver : public Observer
{
private:	
	floatlist*			sst_observations;
	floatlist*			ssr_observations;
	floatlist*			sse_observations;
	floatlist*			mse_observations;
	floatlist*			f_observations;
	floatlist*			rr_observations;
	floatlist*			r_observations;
	floatlist*			plot_observations;
	unsigned short		initial_runs;

public:
	AnovaObserver(FocusRegistry* _registry, unsigned short _runs);
	~AnovaObserver();
	void reset();
	void init();

	void observe(int _run);
	void calc_stats();

	void report_variable_names(ostream& strm=cout) const;
	void report(ostream& strm=cout) const;
};

class FunctionalStabilityObserver : public Observer
{
private:
	intlist*			order_observations;
	unsigned short		max_order;
	unsigned short		observations;
	unsigned short		percentage;

public:
	FunctionalStabilityObserver(FocusRegistry* _registry, unsigned short _max_order, unsigned short _percentage);
	~FunctionalStabilityObserver();

	void reset();
	void init();

	void observe(int _run);
	void calc_stats() {};

	void report_variable_names(ostream& strm=cout) const;
	void report(ostream& strm=cout) const;
};

class PlotObserver : public Observer
{
private:
	unsigned short		max_plots;
	unsigned short		number_of_constraints;
	floatlist*			constraint_values;
	dintcube*			pred_plot_id_observations;
	dintcube*			resp_plot_id_observations;
	dfloatcube*			plot_pred_observations;
	dfloatcube*			plot_resp_observations;
	const char* 		plot_set_type;

public:
	PlotObserver(FocusRegistry* _registry, unsigned short _max_plots, unsigned short _runs, unsigned short _constraints);
	~PlotObserver();

	void reset() {};
	void init() {};

	void observe(int _run);
	void calc_stats() {};

	void report_variable_names(ostream& strm=cout) const;
	void report(ostream& strm=cout) const;
};

#endif
