/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __CONTEXT_CPP
#define __CONTEXT_CPP

#include "context.h"
#include "logging.h"
#include "focusregistry.h"
#include <algorithm>

SpatialContext::SpatialContext(const char* _name, const char* _class_name)
{
	name = _name;
	class_name = _class_name;
}

SpatialContext::~SpatialContext()
{
}

bool SpatialContext::operator==(const SpatialContext& _context) const
{
	return  name == _context.name &&
			class_name == _context.class_name;
}

bool SpatialContext::operator!=(const SpatialContext& _context) const
{
	return !((*this)==_context);
}
	
bool SpatialContext::operator <(const SpatialContext& _context) const
{
	Logging::log_error("SpatialContext::operator < should only be called on derived classes",NULL);
	return true;
}

void SpatialContext::report(ostream& strm) const
{
	strm<<class_name<<"::"<<name;
}

CircularPlotBuffer::CircularPlotBuffer(const char* _name) : SpatialContext(_name, "CircularPlotBuffer")
{
	distance = NULL_DOUBLE;
}

CircularPlotBuffer::CircularPlotBuffer(const char* _name, double _distance) : SpatialContext(_name, "CircularPlotBuffer")
{
	distance = _distance;
}

CircularPlotBuffer::~CircularPlotBuffer()
{
}

bool CircularPlotBuffer::operator==(const CircularPlotBuffer& _buffer) const
{
	return	name == _buffer.name && 
			class_name == _buffer.class_name &&
			distance == _buffer.distance;
}

bool CircularPlotBuffer::operator <(const CircularPlotBuffer& _buffer) const
{
	return distance < _buffer.distance;
}

void CircularPlotBuffer::report(ostream& strm) const
{
	SpatialContext::report(strm);
	strm<<"(distance="<<distance<<")\n";
}

SpatialContextList::SpatialContextList(FocusRegistry* _registry)
{
	sort_status = UNSORTED;
	registry	= _registry;
	registry->registerSpatialContextList(this);
}

SpatialContextList::~SpatialContextList()
{
	clear();
}
	
void SpatialContextList::addSpatialContext(SpatialContext* _context)
{
	push_back(_context);
}

void SpatialContextList::sortAscending()
{
	if(sort_status != ASCENDING)
	{
		sort(begin(), end(), Less_SpatialContext());
		sort_status = ASCENDING;
	}
}

void SpatialContextList::sortDescending()
{
	if(sort_status != DESCENDING)
	{
		sort(begin(), end(), Greater_SpatialContext());
		sort_status = DESCENDING;
	}
}

void SpatialContextList::report(ostream& strm) const
{
	SpatialContextList::const_iterator context_iterator = begin();
	while(context_iterator != end())
		(*context_iterator++)->report(strm);
}

#endif