/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __STATISTICS_H
#define __STATISTICS_H

#include <iostream>
#include "focusexception.h"

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class FocusRegistry;

class AnovaData
{
private:
	double sst;			//total sum of squares
	double ssr;			//explained sum of squares
	double sse;			//residual (error or unexplained) sum of squares
	double mse;			//error mean square
	double f;			//f value
	double rr;			//r-square
	double r;			//r value
	int	   n;           //size of the data set

public:
	AnovaData();
	~AnovaData() {};

	void set_sst(double _sst)			{ sst = _sst; };
	double get_sst() const				{ return sst; };

	void set_ssr(double _ssr)			{ ssr = _ssr; };
	double get_ssr() const				{ return ssr; };

	void set_sse(double _sse)			{ sse = _sse; };
	double get_sse() const				{ return sse; };

	void set_mse(double _mse)			{ mse = _mse; };
	double get_mse() const				{ return mse; };

	void set_f(double _f)				{ f = _f; };
	double get_f() const				{ return f; };

	void set_rr(double _rr)				{ rr = _rr; };
	double get_rr()	const				{ return rr; };

	void set_r(double _r)				{ r = _r; };
	double get_r()	const				{ return r; };

	void set_n(int _n)					{ n = _n; };
	int get_n() const					{ return n; };

	void report(ostream& strm=cout) const;
};

class RegressionData
{
private:
	double*			m;				//order terms, fitting parameters
	double			b;				//intercept at Y axis
	unsigned short	order;			//order of this polynomial regression
	double*			xobs;			//observed predictor values (x)
    double*			yobs;			//observed response values  (y)
	double*			ypred;			//predicted response values
	int				n;				//size of the data set

public:
	RegressionData() {};
	RegressionData(unsigned short _order);
	~RegressionData();

	void set_m(unsigned short _order, double _m);
	double get_m(unsigned short _order) const; 

	void set_b(double _b)					{ b = _b; };
	double get_b() const					{ return b; };

	void set_n(int _n)						{ n = _n; };
	int get_n() const						{ return n; };

	unsigned short get_order() const		{ return order; };

	void set_xobs(double* _xobs)			{ xobs = _xobs; }
	double* get_xobs() const				{ return xobs; };

	void set_yobs(double* _yobs)			{ yobs = _yobs; }
	double* get_yobs() const				{ return yobs; };

	void set_ypred(double* _ypred)			{ ypred = _ypred; }
	double* get_ypred() const				{ return ypred; };

	void report(ostream& strm=cout) const;
};

class Statistics
{
private:
	FocusRegistry*			registry;
	double					critical_f_values[34][19];		//at alpha = 0.05

public:
	Statistics(FocusRegistry* _registry);
	~Statistics() {};

	double get_critical_f_value(int _dfdenom, int _dfnumer) const;

	RegressionData* regression(double* _xobs, double* _yobs, int _n, unsigned short _order) throw (FocusException);
	AnovaData* anova(double* _yobs, double* _ypred, int _n, float _m_0);
	double correlation(double* _xobs, double* _yobs, int _n);
	unsigned short functional_stability_test(double* _xobs, double* _yobs, int _n, unsigned short _order);

private:
	void init_critical_f_values();
};


#endif