/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __LOGGING_CPP
#define __LOGGING_CPP

#include "logging.h"
#include "focusutil.h"
#include "stdarg.h"

#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>

#ifdef LOG_FILE
const char* Logging::destination = "focus23.log";
ofstream* Logging::logfilestream = new ofstream(destination, ios::out|ios::app);
#endif

void Logging::set_destination(const char* _destination)	
{ 
#ifdef LOG_FILE

	destination = _destination;
	struct _stat buf;
	int fh, result;
	char buffer[] = "A line to output";

	if( (fh = _open(_destination, _O_APPEND)) ==  -1 )
		_write( fh, buffer, strlen( buffer ) );

	result = _fstat( fh, &buf );

	if( result != 0 )
	{
		Logging::log_error("Logging::set_destination(",_destination,") cannot access logfile for rotation!",NULL);
		return;
	}
	if(buf.st_size > 10000000)
	{
		logfilestream->close();
		logfilestream = new ofstream(destination, ios::out);
	}
	_close( fh );
	
	(*logfilestream)<<"\n\n";
#endif
}

void Logging::close_destination()
{
#ifdef LOG_FILE
	logfilestream->close();	
#endif
}

void Logging::log_error(const char* m1, ...)
{
#ifdef LOG_ERROR
#ifdef LOG_FILE
	(*logfilestream)<<"ERROR ";
	Utility::write_date(*logfilestream);
	(*logfilestream)<<m1;

	va_list ap1;
	va_start(ap1, m1);	
	for(;;)
	{
		char* mx = va_arg(ap1,char*);
		if(mx==NULL) 
			break;
		(*logfilestream)<<mx;
	}
	va_end(ap1);
	(*logfilestream)<<"\n";
	logfilestream->flush();
#endif
	cout<<"\nERROR ";
	Utility::write_date(cout);
	cout<<m1;
	
	va_list ap2;
	va_start(ap2, m1);	
	for(;;)
	{
		char* mx = va_arg(ap2,char*);
		if(mx==NULL) 
			break;
		cout<<mx;
	}
	va_end(ap2);
	cout<<"\n";
#endif
}
	
void Logging::log_info(bool _header, const char* m1, ...)
{
#ifdef LOG_INFO
#ifdef LOG_FILE
	if(_header)
	{
		(*logfilestream)<<"INFO ";
		Utility::write_date(*logfilestream);
	}
	(*logfilestream)<<m1;

	va_list ap1;
	va_start(ap1, m1);	
	for(;;)
	{
		char* mx = va_arg(ap1,char*);
		if(mx==NULL) 
			break;
		(*logfilestream)<<mx;
	}
	va_end(ap1);
	logfilestream->flush();
#endif
#ifdef LOG_SCREEN
	if(_header)
	{
		cout<<"INFO ";
		Utility::write_date(cout);
	}
	cout<<m1;
	va_list ap2;
	va_start(ap2, m1);	
	for(;;)
	{
		char* mx = va_arg(ap2,char*);
		if(mx==NULL) 
			break;
		cout<<mx;
	}
	va_end(ap2);
#endif
#endif
}

void Logging::log_debug(const char* m1, ...)
{
#ifdef LOG_DEBUG
#ifdef LOG_FILE
	(*logfilestream)<<"DEBUG ";
	Utility::write_date(*logfilestream);
	(*logfilestream)<<m1;

	va_list ap1;
	va_start(ap1, m1);	
	for(;;)
	{
		char* mx = va_arg(ap1,char*);
		if(mx==NULL) 
			break;
		(*logfilestream)<<mx;
	}
	va_end(ap1);
	(*logfilestream)<<"\n";
	logfilestream->flush();
#endif
#ifdef LOG_SCREEN
	cout<<"DEBUG ";
	Utility::write_date(cout);
	cout<<m1;
	
	va_list ap2;
	va_start(ap2, m1);	
	for(;;)
	{
		char* mx = va_arg(ap2,char*);
		if(mx==NULL) 
			break;
		cout<<mx;
	}
	va_end(ap2);
	cout<<"\n";
#endif
#endif
}

#endif