/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __UTIL_H
#define __UTIL_H

#include <iostream>
#include "defs.h"

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif


class Utility
{
	static struct tm d;	
	static long ltime;

public:

	Utility() {};
	~Utility() {};

	//writes formatted date to ouput stream
	static void write_date(ostream& strm=cout);

	//get formatted date string 
	static char* get_date_string();

	//generates a random number between from and to (from and to are included)
	static float Utility::randint(int from, int to);
	
	//generates a random number between 0 and range (range is included)
	static int randint(int range=100);

	//generates a random number between from and to (from and to are included)
	static float randfloat(float from, float to);

	//generates a floating point number between 0 and range (range is included) 
	static float randfloat(float range=1);

	//transforms an integer into a const char*
	static const char* int_to_char(int _val);

	//transforms a float into a const char*
	static const char* float_to_char(float _val);

	//rounds a float value into an integer
	static int round(float _val);
 };
 
 #endif