/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __FOCUS_REGISTRY_CPP
#define __FOCUS_REGISTRY_CPP

#include "observer.h"
#include "distance.h"
#include "plot.h"
#include "context.h"
#include "inputreader.h"
#include "outputwriter.h"
#include "sampler.h"
#include "statistics.h"
#include "controller.h"
#include "focusregistry.h"

FocusRegistry::FocusRegistry()
{
	plots = NULL;
	reader = NULL;
	writer = NULL;
	contexts = NULL;
	sampler = NULL;
	statistics = NULL;
	controller = NULL;
	observer_list = new ObserverList();
}

FocusRegistry::~FocusRegistry()
{
}

void FocusRegistry::registerPlotSetList(PlotSetList* _plots)
{
	plots = _plots;
}

void FocusRegistry::registerInputReader(InputReader* _reader)
{
	reader = _reader;
}

void FocusRegistry::registerOutputWriter(OutputWriter* _writer)
{
	writer = _writer;
}

void FocusRegistry::registerSpatialContextList(SpatialContextList* _contexts)
{
	contexts = _contexts;
}

void FocusRegistry::registerSampler(Sampler* _sampler)
{
	sampler = _sampler;
}

void FocusRegistry::registerStatistics(Statistics* _statistics)
{
	statistics = _statistics;
}

void FocusRegistry::registerController(Controller* _controller)
{
	controller = _controller;
}

void FocusRegistry::addObserver(Observer* _observer)
{
	observer_list->push_back(_observer);
}

PlotSetList* FocusRegistry::getPlotSetList()
{
	return plots;
}

SpatialContextList* FocusRegistry::getSpatialContextList() throw (FocusException)
{
	if(contexts)
		return contexts;
	throw FocusException("FocusRegistry::getSpatialContextList(): cannot deliver undefined getSpatialContextList!");
}
	
InputReader* FocusRegistry::getInputReader() throw (FocusException)
{
	if(reader)
		return reader;
	throw FocusException("FocusRegistry::getInputReader(): cannot deliver undefined InputReader object!");

}

OutputWriter* FocusRegistry::getOutputWriter() throw (FocusException)
{
	if(writer)
		return writer;
	throw FocusException("FocusRegistry::getOutputWriter(): cannot deliver undefined OutputWriter object!");

}

Sampler* FocusRegistry::getSampler() throw (FocusException)
{
	if(sampler)
		return sampler;
	throw FocusException("FocusRegistry::getSampler(): cannot deliver undefined Sampler object!");
}

Statistics* FocusRegistry::getStatistics() throw (FocusException)
{
	if(statistics)
		return statistics;
	throw FocusException("FocusRegistry::getStatistics(): cannot deliver undefined Statistics object!");
}

Controller* FocusRegistry::getController() throw (FocusException)
{
	if(controller)
		return controller;
	throw FocusException("FocusRegistry::getController(): cannot deliver undefined Controller object!");
}

#endif