/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __DISTANCE_H
#define __DISTANCE_H

#include "defs.h"
#include "plot.h"
#include "focusexception.h"
#include <vector>
#include <iostream>
#include <functional>

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class Distance
{
private: 

	double	distance;	//distance
	Plot*	plot_1;	
	Plot*	plot_2;

public:

	Distance();
	Distance(Plot* _plot_1, Plot* _plot_2);
	Distance(double _distance, Plot* _plot_1, Plot* _plot_2);
	~Distance();

	bool operator==(const Distance& _distance) const;
	bool operator!=(const Distance& _distance) const;
	bool operator<(const Distance& _distance) const;

	void setDistance(double _distance)			{ distance = _distance; };
	double getDistance() const					{ return distance; };

	void calculateDistance() throw (FocusException);

	void setPlot_1(Plot* _plot_1)				{ plot_1 = _plot_1; };
	Plot* getPlot_1() const						{ return plot_1; };

	void setPlot_2(Plot* _plot_2)				{ plot_2 = _plot_2; };
	Plot* getPlot_2() const						{ return plot_2; };

	void report(ostream& strm=cout) const;
};

class FocusRegistry;

class DistanceList : public vector<Distance>
{
private:
	sort_types			sort_status;

public:
	DistanceList();
	~DistanceList();

	void addDistance(Distance& _distance);
	void sortAscending();
	void sortDescending();
	sort_types getSort_status() const			{ return sort_status; };		
	
	void calculateDistances() throw (FocusException);
	
	void unselectPlotsWithinDistance(Plot* _plot, double _distance);
	void verifyPlotsWithinDistance(double _distance);
	
	void unselectPlotsOutsideDistance(Plot* _plot, double _distance);
	void verifyPlotsOutsideDistance(double _distance);

	void report(ostream& strm=cout) const;
};

class Less_Distance : public binary_function<Distance, Distance, bool> 
{
public:
	bool operator()(Distance _x, Distance _y) 
	{ 
		return _x < _y; 
	}
};

class Greater_Distance : public binary_function<Distance, Distance, bool> 
{
public:
	bool operator()(Distance _x, Distance _y) 
	{ 
		return !(_x < _y); 
	}
};


#endif