/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __DYNINTARRAY_H
#define __DYNINTARRAY_H

//dintlist is a dynamic list of int values,  dynamic
//means, you can add single list_elements (integer), 
//listsize is not to be defined somewhere

//intlist is a nondynamic intarray, listsize has to be 
//defined at constructur call, no changes in size possible

//dintarr is a dynamic array of int values, dynamic means
//you can add a intlist any time as long as memory is available, 

//dintcube is a dynamic cube (3D) of int values, you can 
//add a dintarray any time

#include <iostream>
#include <math.h>

#if !defined (STLPORT) || defined(__STL_USE_NAMESPACES)
using namespace std;
#endif

struct int_el
{
	int ival;
	int_el* right;
};

//one dimensional dynamic array of integers

class dintlist
{
	int_el* leftint;
	int_el* rightint;
public:
	dintlist();
	//creates dintlist, initialize with 0
	dintlist(int x);
	//copy constructor
	dintlist(dintlist& ilist);
	~dintlist();
	//delete int_els
	void reset();
	
	void add(int i);
	int& operator[](int x);
	int operator=(dintlist& ilist);
	int operator==(dintlist& ilist);
	int operator!=(dintlist& ilist);
	int last_el() const;
	int entries() const;
	int index_of(int val) const;
        int pos_entries() const;
	void report(ostream& strm=cout) const;

	float mean() const;
        int min()  const;
        int max()  const;
        float varianz()  const;
        float stderro() const;
		
	void asc_sort();        //sort in ascending order
	void desc_sort();       //sort in descending order
private:
	void error(int n, float val=0) const;
};

//one dimensional array of integers, not dynamic, size has
//to be defined at constructor call!!

class intlist
{
	int	size;		//size of the list
	int* 	ilist;		//array of int
public:
	intlist(int x);
	intlist(intlist& il);
	~intlist();

	int& operator[](int x);
	int operator=(intlist& il);
        int operator==(intlist& il) const;
        int operator!=(intlist& il) const;
        int entries() const	{ return size; }
	int index_of(int val) const;
	int lastindex_of(int val) const;
	
        void report(ostream& strm=cout) const;

	float mean() const;
        int min()  const;
        int max()  const;
        float varianz()  const;
        float stderro() const;
private:
        void error(int n, float val=0) const;
};

struct intlist_el
{
	intlist* ilval;
	intlist_el* right;
};

//two dimensional dynamic array of integers, based on intlist

class dintarray
{
	intlist_el* toplist;
	intlist_el* bottomlist;	
public:
	dintarray();
	//creates dintarray, initialize with 0
	dintarray(int x, int y);
	//copy constructor
	dintarray(dintarray& iarr);
	~dintarray();
	void reset();

	intlist& operator[](int y);
	//assign with real clone
	int operator=(dintarray& iarr);
	int operator==(dintarray& iarr);
	int operator!=(dintarray& iarr);
	int add(intlist* il);
	int entries() const;
	void report(ostream& strm=cout) const;
private:
	void error(int n, float val=0) const;
};

struct intarray_el
{
	dintarray iaval;
	intarray_el* right;
};

//three dimensional dynamic array fo integers

class dintcube
{
	intarray_el* frontarray;
	intarray_el* backarray;
public:
	dintcube();
	dintcube(int x, int y, int z);
	~dintcube();
	void reset();
	
	dintarray& operator[](int z);
	int operator=(dintcube& icube);
	int operator==(dintcube& icube);
	int operator!=(dintcube& icube);
	int add(dintarray ia);
	int entries() const;
	void report(ostream& strm=cout) const;
private:
        void error(int n, float val=0) const;
};

#endif
