/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __DYNINTARRAY_CPP
#define __DYNINTARRAY_CPP

#include "diarr.h"
#include <stdlib.h>

//********************************************************************************  

dintlist::dintlist()
{
	leftint=NULL;
	rightint=NULL;
}

dintlist::dintlist(int x)
{
	leftint=NULL;
	rightint=NULL;
	for(int i=0; i<x; i++)
		add(0);
}

dintlist::dintlist(dintlist& ilist)
{
	leftint=NULL;
	rightint=NULL;
	int listsize=ilist.entries();
        for(int i=0; i<listsize; i++)
                add(ilist[i]);
}

dintlist::~dintlist()
{
	reset();
}

void dintlist::reset()
{
        int_el* current=leftint;
    	int_el* next;
	while(current)
	{
        	next=current->right;
        	delete current;
        	current=next;
    	}
    	leftint=NULL;
	rightint=NULL;
}

void dintlist::add(int i)
{
	int_el* new_el=new int_el;
	if(!new_el)
	{
		error(1);
		exit(1);
	}
	if(!leftint)
                leftint=new_el;
	new_el->ival=i;
	if(rightint)
		rightint->right=new_el;
	new_el->right=NULL;
	rightint=new_el;
}

int& dintlist::operator[](int x)
{
	int_el* current=leftint;
        int count=0;
        while(current)
        {
                if(count==x)
                        return current->ival;
                current=current->right;
                count++;
        }
        error(3,(float)x);
	int* retval=new int(-1); 
        return *retval;
}

int dintlist::entries() const
{
    	int_el* current=leftint;
	int count=0;
    	while(current)
        {
                count++;
                current=current->right;
    	}
    	return count;
}

int dintlist::last_el() const
{
	int_el* current=leftint;
        int val=0;
        while(current)
        {
		val=current->ival;
                current=current->right;
        }
        return val;
}

int dintlist::index_of(int val) const
{
	int_el* current=leftint;
        int count=0;
        while(current)
        {
		if(current->ival==val)
                	return count;
		count++;
                current=current->right;
        }
        return -1;
}

int dintlist::operator=(dintlist& ilist) 
{
	int listsize=ilist.entries();
	reset();
	for(int i=0; i<listsize; i++)
                add(ilist[i]);
	return 1;
}

int dintlist::operator==(dintlist& ilist)
{
	int listsize=ilist.entries();
        if(listsize!=entries())
		return 0;
        for(int i=0; i<listsize; i++)
	{
		if((*this)[i]!=ilist[i])
			return 0;
	}
	return 1;
}

int dintlist::operator!=(dintlist& ilist)
{
	if(*this==ilist)
		return 0;
	return 1;
}

void dintlist::report(ostream& strm) const
{
	strm<<"[ ";
	int_el* current=leftint;
	while(current)
	{
		strm.width(3);
		strm<<current->ival<<" ";
		current=current->right;
	}
	strm<<"]"<<endl;
}

void dintlist::error(int n, float val) const
{
	cout <<"ERROR CLASS dintlist ::";
	switch(n) {
	case 1: cout<<"add(): lack of memory!"<<endl; break;
	case 2: cout<<"set(): position: "<< (int)val<< " out of permitted range: ";
		cout<<entries()<<" !"<<endl;
		break;
	case 3: cout<<"[]: index: "<< (int)val<< " out of range: ";
                cout<<"[0.."<<entries()<<"]!"<<endl;
		break; 
	default: cout << "error(): no error et all?" << endl;
        }
}
 
float dintlist::mean() const
{
        int_el* current=leftint;
        float sum=0;
        int count=0;
        while(current)
        {
                //if(current->ival>0)
                {
                        sum+=current->ival;
                        count++;
                }
                current=current->right;
        }
        if(count>0)
                return sum/=float(count);
        return 0;
}
 
int dintlist::min() const
{
        int_el* current=leftint;
        int min=65000;
        while(current)
        {
                if(current->ival<min)
                        min=current->ival;
                current=current->right;
        }
	if(min != 65000)
        	return min;
	return 0;
}
 
int dintlist::max() const
{
        int_el* current=leftint;
        int max=-65000;
        while(current)
        {
                if(current->ival>max)
                        max=current->ival;
                current=current->right;
        }
        return max;
}

float dintlist::varianz() const
{
        int_el* current=leftint;
        double sum=0;
        int count=0;
        float xq=mean();
        while(current)
        {
			sum+=pow((current->ival-xq),2);
			count++;
			current=current->right;
        }
        if(count>1)
                return (float)(sum/=(float)(count));
        return 0;
}
 
float dintlist::stderro() const
{
        int count=entries();
        if(count>0)
                return (float)(1.96*(sqrt((float)varianz())/sqrt((float)count)));
        return 0;
}

//sorts elements of the list in descending order
 
void dintlist::desc_sort()
{
        int size=entries();
        int sortstep=0;
        int index, minindex;
        int min;
        while(sortstep<size)
        {
                min=65000;
                minindex=0;
                int_el* current=leftint;
                //find the largest value which has not yet been sorted
                for(index=0; index<size; index++)
                {
                        if(index>=sortstep && current->ival<min)
                        {
                                min=current->ival;
                                minindex=index;
                        }
                        current=current->right;
                }
                index=0;
                current=leftint;
                int_el* prev_el=NULL;
                //second iteration to relocate (switching pointers) the max element
                while(index<minindex)
                {
                        prev_el=current;
                        current=current->right;
                        index++;
                }
                if(prev_el)
                {
                        prev_el->right=current->right;
                        current->right=leftint;
                        leftint=current;
                }
                sortstep++;
        }
}

//sorts elements of the list in ascending order

void dintlist::asc_sort()
{
        int size=entries();
        int sortstep=0;
        int index, maxindex;
        int max;
        while(sortstep<size)
        {
                max=0;
                maxindex=0;
                int_el* current=leftint;
                //find the largest value which has not yet been sorted
                for(index=0; index<size; index++)
                {
                        if(index>=sortstep && current->ival>=max)
                        {
                                max=current->ival;
                                maxindex=index;
                        }
                        current=current->right;
                }
                index=0;
                current=leftint;
                int_el* prev_el=NULL;
                //second iteration to relocate (switching pointers) the max element
                while(index<maxindex)
                {
                        prev_el=current;
                        current=current->right;
                        index++;
                }
                if(prev_el)
                {
                        prev_el->right=current->right;
                        current->right=leftint;
                        leftint=current;
                }
                sortstep++;
        }
}

//******************************************************************************** 

intlist::intlist(int x)
{
	size=x;
	ilist=new int[size];
	if(!ilist)
	{
		error(1);
		exit (1);
	}
	for(int i=0; i<size; i++)
		ilist[i]=0;
}

intlist::intlist(intlist& il)
{
	size=il.entries();
	ilist=new int[size];
	if(!ilist) 
        { 
                error(1);
                exit (1); 
        } 
	for (int i=0; i<size; i++)
                ilist[i]=il[i];
}

intlist::~intlist()
{
        delete ilist;
}

int& intlist::operator[](int x)
{
	if(x<size)
		return ilist[x];
	error(2,(float)x);
	int* dummy=new int(-1);
	return *dummy;
}

int intlist::operator=(intlist& il)
{
	delete ilist;
        size=il.entries();
        ilist=new int[size];
        if(!ilist)
        {
                error(3);
                exit (1);
        }
        for (int i=0; i<size; i++)
                ilist[i]=il[i];
        return 1;
}

int intlist::operator==(intlist& il) const
{
        if(size!=il.entries())
                return 0;
        for(int i=0; i<size; i++)
        {
                if(ilist[i]!=il[i])
                    	return 0;
        }
        return 1;
}

int intlist::index_of(int val) const
{
	for(int i=0; i<size; i++)
		if(ilist[i]==val)
			return i;
	return -1;
}

int intlist::lastindex_of(int val) const
{
	int index=-1;
        for(int i=0; i<size; i++)
                if(ilist[i]==val)
                        index=i;
        return index;
}

int intlist::operator!=(intlist& il) const
{
        if(*this==il)
                return 0;
        return 1;
}

void intlist::report(ostream& strm) const
{	
	for(int i=0; i<size; i++)
	{
		strm<<ilist[i]<<",";
    }
}

void intlist::error(int n, float val) const
{
        cout <<"ERROR CLASS intlist ::";
        switch(n) {
	case 1: cout<<"intlist(): lack of memory!" << endl;
		break;
	case 2: cout<<"[]: index: "<< (int)val<< " out of range: ";
                cout<<"[0.."<<entries()<<"]!"<<endl;
                break;
	case 3: cout<<"operator=(): lack of memory!" << endl;
                break;
        default: cout << "error(): no error et all?" << endl;
        }
}

float intlist::mean() const
{
        if(ilist && size>0)
        {
                float sum=0;
                int count=0;
                for(int i=0; i<size; i++)
                        //if(ilist[i]>0)
                        {
                                sum+=ilist[i];
                                count++;
                        }
                if(count>0)
                        return sum/=float(count);
                return 0;
        }
        return 0;
}
 
int intlist::min() const
{
        if(ilist && size>0)
        {
                int min=65000;
                for(int i=0; i<size; i++)
                        if(ilist[i]<min)
                                min=ilist[i];
                return min;
        }
        return 0;
}        
 
int intlist::max() const
{
        if(ilist && size>0)
        {
                int max=-65000;
                for(int i=0; i<size; i++)
                        if(ilist[i]>max)
                                max=ilist[i];
                return max;
        }
        return 0;
} 

float intlist::varianz() const
{
        if(ilist && size>0)
        {
            double sum=0;
            int count=0;
            float xq=mean();
            for(int i=0; i<size; i++)
            {
                    sum+=pow((ilist[i]-xq),2);
                    count++;
            }
            if(count>1)
                    return (float)(sum/=(float)(count));
            return 0;
        }
        return 0;
}
 
float intlist::stderro() const
{
        if(ilist && size>0)
			return (float)(1.96*(sqrt(varianz())/sqrt((float)size)));
        return 0;
}

//********************************************************************************

dintarray::dintarray()
{
	toplist=NULL;
	bottomlist=NULL;
}

dintarray::dintarray(int x, int y)
{
	toplist=NULL;
        bottomlist=NULL;
	for(int i=0; i<y; i++)
		add(new intlist(x));
}

dintarray::dintarray(dintarray& iarr)
{
	toplist=NULL;
        bottomlist=NULL;
        int listsize=iarr.entries();
        for(int i=0; i<listsize; i++)
                add(new intlist(iarr[i]));
}

dintarray::~dintarray()
{
	reset();
}

void dintarray::reset()
{
	intlist_el* current=toplist;
	intlist_el* next;
	while(current)
	{
		next=current->right;
		delete current->ilval;
		delete current;
		current=next;
	}
	toplist=NULL;
	bottomlist=NULL;
}

int dintarray::add(intlist* il)
{
	intlist_el* new_el=new intlist_el;
	if(!new_el)
	{
		error(1);
		exit(1);
	}
	if(!&il)
	{
		error(2);
		return 0;
	}
	if(!toplist)
                toplist=new_el;
        new_el->ilval=il;
        if(bottomlist)
                bottomlist->right=new_el;
        new_el->right=NULL;
        bottomlist=new_el;
	return 1;
}

intlist& dintarray::operator[](int y)
{
        intlist_el* current=toplist;
        int count=0;
        while(current)
        {
                if(count==y)
                        return *current->ilval;
                current=current->right;
                count++;
        }
        error(3,(float)y);
        intlist* retval=new intlist(0);
        return *retval;
}

int dintarray::entries() const
{
	intlist_el* current=toplist;
        int count=0;
        while(current)
        {
                count++;
                current=current->right;
        }
        return count;
}

int dintarray::operator=(dintarray& iarr)
{
	int rows=iarr.entries();
	reset();
	for(int i=0; i<rows; i++)
		add(new intlist(iarr[i]));		
	return 1;
}

int dintarray::operator==(dintarray& iarr)
{
        int rows=iarr.entries();
        if(rows!=entries())
                return 0;
        for(int i=0; i<rows; i++)
        {
                if((*this)[i]!=iarr[i])
                        return 0;
        }
        return 1;
}

int dintarray::operator!=(dintarray& iarr)
{
	if(*this==iarr)
		return 0;
	return 1;
}

void dintarray::report(ostream& strm) const
{
	intlist_el* current=toplist; 
        while(current) 
        { 
		current->ilval->report(strm);
                current=current->right; 
        } 
}

void dintarray::error(int n, float val) const
{
	cout<<"ERROR CLASS dintarray ::";
        switch(n) {
        case 1: cout<<"add(): lack of memory!"<<endl; break;
	case 2: cout<<"add(): list to be added was NULL!"<<endl;break;
        case 3: cout<<"[]: index "<< (int)val<< " out of range: ";
                cout<<"[0.."<<entries()<<"]!"<<endl;
                break;
        default: cout << "error(): no error et all?" << endl;
        }
}

//********************************************************************************

dintcube::dintcube()
{
	frontarray=NULL;
	backarray=NULL;
}
 
dintcube::dintcube(int x, int y, int z)
{
	frontarray=NULL;
        backarray=NULL;
        for(int i=0; i<z; i++)
                add(dintarray(x,y));
}

dintcube::~dintcube()
{
        reset();
}

void dintcube::reset()
{
        intarray_el* current=frontarray;
        intarray_el* next;
        while(current)
        {
                next=current->right;
                current->iaval.reset();
                delete current;
                current=next;
        }
	frontarray=NULL;
        backarray=NULL;
}
 
int dintcube::add(dintarray ia)
{
        intarray_el* new_el=new intarray_el;
        if(!new_el)
        {
                error(1);
                exit(1);
        }
        if(!&ia)
        {
                error(2);
                return 0;
        }
        if(!frontarray)
                frontarray=new_el;
        new_el->iaval=ia;
        if(backarray)
                backarray->right=new_el;
        new_el->right=NULL;
        backarray=new_el;
        return 1;
}

dintarray& dintcube::operator[](int z)
{
        intarray_el* current=frontarray;
        int count=0;
        while(current)
        {
                if(count==z)
                        return current->iaval;
                current=current->right;
                count++;
        }
        error(3,(float)z);
        dintarray* retval=new dintarray;
        return *retval;
}
 
int dintcube::entries() const
{
        intarray_el* current=frontarray;
        int count=0;
        while(current)
        {
                count++;
                current=current->right;
        }
        return count;
}
 
int dintcube::operator=(dintcube& icube)
{
        int layers=icube.entries();
        reset();
        for(int i=0; i<layers; i++)
                add(dintarray(icube[i]));
        return 1;
}
 
int dintcube::operator==(dintcube& icube)
{
        int layers=icube.entries();
        if(layers!=entries())
                return 0;
        for(int i=0; i<layers; i++)
        {
                if((*this)[i]!=icube[i])
                        return 0;
        }
        return 1;
}
 
int dintcube::operator!=(dintcube& icube)
{
        if(*this==icube)
                return 0;
        return 1;
}
 
void dintcube::report(ostream& strm) const
{
        intarray_el* current=frontarray;
	int layer=0;
        while(current)
        {
		strm<<"LAYER: "<<layer<<endl;
                current->iaval.report(strm);
		strm<<endl;
		layer++;
                current=current->right;
        }
}

void dintcube::error(int n, float val) const
{
        cout<<"ERROR CLASS dintcube ::";
        switch(n) {
        case 1: cout<<"add(): lack of memory!"<<endl; break;
        case 2: cout<<"add(): list to be added was NULL!"<<endl;break;
        case 3: cout<<"[]: index "<< (int)val<< " out of range: ";
                cout<<"[0.."<<entries()<<"]!"<<endl;
                break;
        default: cout << "error(): no error et all?" << endl;
        }
};

#endif
		
