/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __VARIABLE_H
#define __VARIABLE_H

#include "context.h"
#include <iostream>

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class Variable
{
protected:
	const char*		name;
	double			value;
	SpatialContext* context;

public:
	Variable(const char* _name, double _value);
	Variable(const char* _name, double _value, SpatialContext* _context);
	~Variable();

	void setName(const char* _name)						{ name = _name; };
	const char* getName() const							{ return name; };

	void setValue(double _value)						{ value = _value; };
	double getValue() const								{ return value; };

	void setSpatialContext(SpatialContext* _context)	{ context = _context; };
	SpatialContext* getSpatialContext() const			{ return context; };

	void report(ostream& strm=cout) const;
};

#endif