/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __SAMPLER_H
#define __SAMPLER_H

#include "defs.h"
#include <vector>
#include <iostream>
#include <functional>

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

#include "focusexception.h"

class FocusRegistry;

typedef vector<char*> plot_list;
typedef vector<plot_list> sample_history_list;
typedef sample_history_list::iterator sample_history_iterator;

class Sampler
{
private:
	FocusRegistry*			registry;
	unsigned short			maxPlots;
	unsigned int			maxDuplicateTrials;
	bool					allowDuplicateSamples;
	bool					enforceUniqueSamples;

	sample_history_list		sampleHistory;
	sample_history_iterator	sampleIterator;

public:
	Sampler(FocusRegistry* _registry);
	Sampler(FocusRegistry* _registry, unsigned short _maxPlots);
	Sampler(FocusRegistry* _registry, unsigned short _maxPlots, bool _dupl, bool _unique);
	Sampler(FocusRegistry* _registry, unsigned short _maxPlots, unsigned int _maxDuplicateTrials, bool _dupl, bool _unique);

	~Sampler();

	void setMaxPlots(unsigned short _maxPlots)		{ maxPlots = _maxPlots; };
	int getMaxPlots()								{ return maxPlots; };

	void setMaxDuplicateTrials(unsigned int _maxDuplicateTrials)	
													{ maxDuplicateTrials = _maxDuplicateTrials; };
	unsigned int getMaxDuplicateTrials()			{ return maxDuplicateTrials; };

	bool getAllowDuplicateSamples()					{ return allowDuplicateSamples; };
	void setAllowDuplicateSamples(bool _dupl)		{ allowDuplicateSamples = _dupl; };
	bool getEnforceUniqueSamples()					{ return enforceUniqueSamples; };
	void setEnforceUniqueSamples(bool _unique)		{ enforceUniqueSamples = _unique; };

	void sampleByDistance(double _distance, sample_types _sample_type, 
						  variable_types _variable_type, plotset_types _plotset_type) throw (FocusException);
	void resetSampleHistory();

private:
	bool checkForDuplicateSample(sample_history_iterator& _sampleIterator);
	bool checkForIdenticalSample(sample_history_iterator& _sampleIterator);
	void reportSampleHistory(ostream& strm=cout) const;
};


class Greater_Char : public binary_function<const char*, const char*, bool> 
{
public:
	bool operator()(const char* _x, const char* _y) 
	{ 
		return _x > _y; 
	}
};

class Less_Char : public binary_function<const char*, const char*, bool> 
{
public:
	bool operator()(const char* _x, const char* _y) 
	{ 
		return _x < _y; 
	}
};

#endif