/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __PLOT_H
#define __PLOT_H

#include "variable.h"
#include "constraint.h"
#include <vector>
#include <iostream>

class DistanceList;
class FocusRegistry;

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

typedef vector<Variable> variable_list;

class Plot
{
private: 
	const char*			id;					//plot id
	double				x;					//x coordinate of the plot
	double				y;					//y coordinate of the plot
	bool				selected;			//true = includes plot into analyses
	variable_list		response_variables;
	variable_list		predictor_variables;

public:

	Plot(const char* _id);
	Plot(const char* _id, double _x, double _y);
	~Plot();

	void setId(const char* _id)		{ id = _id; };
	const char* getId() const		{ return id; };

	void setX(double _x)			{ x = _x; };
	double getX() const				{ return x; };

	void setY(double _y)			{ y = _y; };
	double getY() const				{ return y; };

	void select()					{ selected = true; }
	void unSelect()					{ selected = false; }
	bool isSelected()				{ return selected; }

	bool operator==(const Plot& _plot) const;
	bool operator!=(const Plot& _plot) const;

	void addPredictor_variable(Variable& _variable);
	void addResponse_variable(Variable& _variable);

	Variable getResponseVariableAtIndex(int _variable_index) const;
	Variable getPredictorVariableAtIndex(int _variable_index) const;
	unsigned short getPredictorVariableIndexByContext(double _distance, sample_types _sample_type) const;

	void report(ostream& strm=cout) const;
};

class PlotList : public vector<Plot*>
{
private:

public:
	PlotList();
	~PlotList();

	void selectAllPlots();
	void enableAllPlots();

	double* getResponseVariableValuesForSelectedPlots(unsigned short _variable_index) const;
	double* getPredictorVariableValuesForSelectedPlots(unsigned short _variable_index) const;
	int getPredictorVariableIndexByContext(double _distance, sample_types _sample_type) const;
	int getNumberOfSelectedPlots() const;

	void addPlot(Plot* _plot);
	Plot* PlotList::findPlot(char* _id) const;

	void report(ostream& strm=cout) const;
	void reportSelectedPlotIds(ostream& strm=cout) const;
	int reportNumberofSelectedPlots(ostream& strm=cout) const;	
};

class PlotSet
{
	PlotList*			plots;
	DistanceList*		distances;
	categories			category;
	ConstraintList*		constraints;
	const char*			reference_name;

public:
	PlotSet(PlotList* _plots, DistanceList* _distances, categories _category, const char* _name);
	~PlotSet();

	void setPlotList(PlotList* _plots)					{ plots = _plots; };
	PlotList* getPlotList() const						{ return plots; };	

	void setDistanceList(DistanceList* _distances)		{ distances = _distances; };
	DistanceList* getDistanceList() const				{ return distances; };

	void setCategory(categories _category)				{ category = _category; };
	categories getCategory() const						{ return category; };

	void setReferenceName(const char* _name)			{ reference_name = _name; };
	const char* getReferenceName() const				{ return reference_name; };

	void setConstraints(ConstraintList* _constraints)	{ constraints = _constraints; };
	ConstraintList* getConstraints() const				{ return constraints; };

};

class PlotSetList: public vector<PlotSet*>
{
	FocusRegistry*		registry;

public:
	PlotSetList(FocusRegistry* _registry);
	~PlotSetList();

	void addPlotSet(PlotSet* _plotSet);
	PlotSet* getPlotSetForReferenceName(const char* _name) const;
};


#endif