/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#include "logging.h"
#include "focusregistry.h"
#include "controller.h"
#include "focusexception.h"
#include "statistics.h"

int main(int argc, char* argv[])
{
	try
	{
		const char* config_filename = NULL;

   		if(argc == 2)
   			config_filename=argv[1];
   	
		Logging::set_destination("focus20.log");
		FocusRegistry registry;
		Controller controller(&registry, config_filename);
		controller.execute();
	}
	catch (FocusException &e)
	{	
		Logging::log_error(e.what(),NULL);
	}	

    return 0;
}