/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __INPUTREADER_H
#define __INPUTREADER_H

#include "defs.h"
#include "focusexception.h"
#include "constraint.h"
#include "tinyxml.h"
#include <string>

class FocusRegistry;

class InputReader
{
private:
	FocusRegistry*	registry;
	TiXmlDocument* xml_parameters;

public:
	InputReader(FocusRegistry*	_registry, const char* _filename);
	~InputReader();

	void readConfiguationFile(const char* _filename) throw (FocusException);
	
	void readPlotDistanceMatrix(const char* _filename) throw (FocusException);
	void readVariables(const char* _filename, variable_types _varType, categories _category = WITHOUT_CONTEXT) throw (FocusException);
	void readPlotVariables(const char* _filename, variable_types _varType) throw (FocusException);

	void validatePlotBufferDataSet(const char* _matrixfilename, const char* _predictorfilename, const char* _responsefilename) throw (FocusException);
	void validatePlotPlotDataSet(const char* _predictorfilename, const char* _responsefilename) throw (FocusException);

	const char* getDistanceMatrixFileName() const throw (FocusException);
	const char* getPredictorVariablesFileName() const throw (FocusException);
	const char* getResponseVariablesFileName() const throw (FocusException);
	const char* getOutputBaseName() const throw (FocusException);

	unsigned short	getNumberOfIterations() const throw (FocusException);
	unsigned short	getMaximumPlotsPerIteration() const throw (FocusException);
	unsigned int	getDuplicateRetrials() const throw (FocusException);
	unsigned short	getMaximumOrder() const throw (FocusException);
	unsigned short  getPercentage() const throw (FocusException);
	bool			getFunctionalStability() const throw (FocusException);
	bool			getDuplicatesAllowedFlag() const throw (FocusException);
	bool			getUniqueEnforceFlag() const throw (FocusException);
	bool			getTimeStamp() const throw (FocusException);
	bool			getStatistics() const throw (FocusException);
	bool			getWritePlots() const throw (FocusException);
	bool			getIncludeZeroRegression() const throw (FocusException);
	plotset_types	getPlotSetType() const throw (FocusException);
	ConstraintList*	getConstraints() const throw (FocusException);

private:
	int read_number_of_lines_from_file(const char* _filename) const	throw (FocusException);
	void verify_distance_matrix_symmetry(const char* _filename) const throw (FocusException);
	void create_plots_from_distance_matrix(const char* _filename) const throw (FocusException);
	void create_plots_and_variables(const char* _filename, variable_types _varType) const throw (FocusException);
	void assign_distances_from_distance_matrix(const char* _filename) throw (FocusException);
	void assign_distances(variable_types _varType) throw (FocusException);

	void create_cirular_plot_buffers(const char* _filename) const throw (FocusException);
	void create_variables(const char* _filename, variable_types _varType, categories _category) const throw (FocusException);

public:
	static const char* TAG_NAME_FOCUS;
	static const char* TAG_NAME_CONFIGURATION;
	static const char* TAG_NAME_NUMBER_OF_ITERATIONS;
	static const char* TAG_NAME_PLOTS_PER_ITERATION;
	static const char* TAG_NAME_INCLUDE_ZERO_REGRESSION;
	static const char* TAG_NAME_DUPLICATE_SAMPLES;
	static const char* TAG_NAME_ALLOW;
	static const char* TAG_NAME_UNIQUE_SAMPLES;
	static const char* TAG_NAME_ENFORCE;
	static const char* TAG_NAME_RETRIALS;
	static const char* TAG_NAME_FUNCTIONAL_STABILITY;
	static const char* TAG_NAME_ENABLE;
	static const char* TAG_NAME_MAXIMUM_ORDER;
	static const char* TAG_NAME_PERCENTAGE_OF_RUNS;
	static const char* TAG_NAME_STATISTICS;
	static const char* TAG_NAME_PLOTSET;
	static const char* TAG_NAME_TYPE;
	static const char* TAG_NAME_INPUTFILES;
	static const char* TAG_NAME_PLOT_DISTANCES;
	static const char* TAG_NAME_PREDICTOR_VARIABLES;
	static const char* TAG_NAME_RESPONSE_VARIABLES;
	static const char* TAG_NAME_OUTPUTFILES;
	static const char* TAG_NAME_BASENAME;
	static const char* TAG_NAME_CONSTRAINTS;
	static const char* TAG_NAME_DISTANCE;
	static const char* TAG_NAME_VALUE;
	static const char* TAG_NAME_MULTIPLIER;
	static const char* TAG_NAME_SAMPLETYPE;
	static const char* TAG_NAME_TIMESTAMP;
	static const char* TAG_NAME_WRITE_PLOTS;
};

struct ltstr
{
  bool operator()(string s1, string s2) const
  {
		return strcmp(s1.c_str(), s2.c_str()) < 0;
  }
};


#endif