/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __UTIL_CPP
#define __UTIL_CPP

#include "focusutil.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

long Utility::ltime = time( &ltime );
struct tm Utility::d = *localtime( &ltime );

void Utility::write_date(ostream& strm)
{
   time( &ltime );
   d = *localtime( &ltime );
   
   char month[10];
   char year[10];
   char day[10];
   char hour[10];
   char min[10];
   char sec[10];
   sprintf(month,"%02d",++d.tm_mon);
   sprintf(year,"%02d",d.tm_year+1900);
   sprintf(day,"%02d",d.tm_mday);
   sprintf(hour,"%02d",d.tm_hour);
   sprintf(min,"%02d",d.tm_min);
   sprintf(sec,"%02d",d.tm_sec);
   
   strm<<"["<<month<<"/"<<day<<"/"<<year<<" "<<hour<<":"<<min<<":"<<sec<<"] ";
}

char* Utility::get_date_string()
{
	time( &ltime );
	d = *localtime( &ltime );

	char* date = new char[20];
	sprintf(date,"_%02d_%02d_%02d_%02d_%02d_%02d",++d.tm_mon, d.tm_mday, d.tm_year+1900, d.tm_hour, d.tm_min, d.tm_sec);	
	return date;
}

int Utility::randint(int range)
{
	return rand() * range / RAND_MAX;
}

float Utility::randint(int from, int to)
{
	if(from < to)
		return (rand() * (to - from + 1 ) / RAND_MAX) + from;
	return (rand() * (from - to) / RAND_MAX) + to;
}

float Utility::randfloat(float range)
{
	return (float)rand() * range / (float)RAND_MAX;
}

float Utility::randfloat(float from, float to)
{
	if(from < to)
		return ((float)rand() * (to - from) / (float)RAND_MAX) + from;
	return ((float)rand() * (from - to) / (float)RAND_MAX) + to;
}

const char* Utility::int_to_char(int _val)
{
	char* buffer = new char[10];
	sprintf(buffer,"%d",_val);
	return buffer;
}


const char* Utility::float_to_char(float _val)
{
	char* buffer = new char[20];
	sprintf(buffer,"%f",_val);
	return buffer;
}

int Utility::round(float _val)
{
	return (int)(_val + 0.5);
}


#endif