/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __FOCUS_REGISTRY_H
#define __FOCUS_REGISTRY_H

#include "focusexception.h"
#include <vector>

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class PlotSetList;
class SpatialContextList;
class InputReader;
class OutputWriter;
class Sampler;
class Statistics;
class Controller;
class AnovaObserver;
class Observer;

typedef vector<Observer*> ObserverList;

class FocusRegistry
{
private:
	PlotSetList*		plots;
	SpatialContextList*	contexts;
	InputReader*		reader;
	OutputWriter*		writer;
	Sampler*			sampler;
	Statistics*			statistics;
	Controller*			controller;
	ObserverList*		observer_list;

public:

	FocusRegistry();
	~FocusRegistry();

	void registerPlotSetList(PlotSetList* _plots);
	void registerSpatialContextList(SpatialContextList* _contexts);
	void registerInputReader(InputReader* _reader);
	void registerOutputWriter(OutputWriter* _writer);
	void registerSampler(Sampler* _sampler);
	void registerStatistics(Statistics* _statistics);
	void registerController(Controller* _controller);
	void addObserver(Observer* _observer);

	PlotSetList* getPlotSetList();
	SpatialContextList* getSpatialContextList() throw (FocusException);
	InputReader* getInputReader() throw (FocusException);
	OutputWriter* getOutputWriter() throw (FocusException);
	Sampler* getSampler() throw (FocusException);
	Statistics* getStatistics() throw (FocusException);
	Controller* getController() throw (FocusException);
	ObserverList* getObserverList() const			{ return observer_list; };
};
 
#endif