/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __DYNFLOATARRAY_H
#define __DYNFLOATARRAY_H

#include <iostream>

#if !defined (STLPORT) || defined(__STL_USE_NAMESPACES)
using namespace std;
#endif

//dfloatlist is a dynamic list float values, dynamic
//means, you can add single list_elements, listsize is not to
//be defined somewhere
//dfloatarr is a dynamic array of pointer to void, dynamic means
//you can add a dfloatlist whith any size or empty any time as
//long as memory is available, however dfloatlist's (rows) cannot be
//changed in size later on, just the number of columns is

struct float_el
{
	float fval;
	float_el* right;
};

//one dimensional dynamic array for floats 

class dfloatlist
{
	float_el* leftfloat;
	float_el* rightfloat;
	
public:
	dfloatlist();
	//creates floatist, initialize with 0
	dfloatlist(int x);
	//copy constructor
	dfloatlist(dfloatlist& flist);
	~dfloatlist();
	//delete int_els
	void reset();
	
	void add(float f);
	float& operator[](int x);
	float last_el() const;
	int operator=(dfloatlist& flist);
	int operator==(dfloatlist& flist);
	int operator!=(dfloatlist& flist);
	int entries() const;
        int index_of(float val) const;
	int pos_entries() const;
	void report(ostream& strm=cout) const;

	float mean() const;
	float min()  const;
	float max()  const;
	float varianz()  const;
	float stderro() const;
	float confidence_interval() const;

	void asc_sort();	//sort in ascending order
	void desc_sort();	//sort in descending order
private:
	void error(int n, float val=0) const;
};

////one dimensional array of integers, not dynamic, size has
//to be defined at constructor call!!

class floatlist
{
	int 	size;		//size of the list
	float*	flist;		//array of float
public:
	floatlist(int x);
        floatlist(floatlist& il);
        ~floatlist();
        void reset();

        float& operator[](int x);
        int operator=(floatlist& il);
        int operator==(floatlist& il) const;
        int operator!=(floatlist& il) const;
        int entries() const;
		int get_size() const	{ return size; };
        int index_of(float val) const;
        void report(ostream& strm=cout) const;

		float mean() const;      
        float min()  const;    
        float max()  const;    
        float varianz()  const;    
        float stderro() const;
		float confidence_interval() const;
private:
        void error(int n, float val=0) const;
};

struct floatlist_el
{
	floatlist* flval;
	floatlist_el* right;
};

//two dimensional dynamic array for floats 

class dfloatarray
{
	floatlist_el* toplist;
	floatlist_el* bottomlist;	

public:
	dfloatarray();
	//creates intarray, initialize with 0
	dfloatarray(int x, int y);
	dfloatarray(dfloatarray& fa);
	~dfloatarray();
	void reset();

	floatlist& operator[](int y);
	//assign with real clone
	int operator=(dfloatarray& farr);
	int operator==(dfloatarray& farr);
	int operator!=(dfloatarray& farr);
	int add(floatlist* fl);
	int entries() const;
	void report(ostream& strm=cout) const;

private:
	void error(int n, float val=0) const;
};

struct floatarray_el
{
        dfloatarray faval;
        floatarray_el* right;
};
 
//three dimensional dynamic array for floats 
 
class dfloatcube
{
        floatarray_el* frontarray;
        floatarray_el* backarray;
public:
        dfloatcube();
        dfloatcube(int x, int y, int z);
        ~dfloatcube();
        void reset();
        
        dfloatarray& operator[](int z);
        int operator=(dfloatcube& fcube);
        int operator==(dfloatcube& fcube);
        int operator!=(dfloatcube& fcube);
        int add(dfloatarray fa);
        int entries() const;
private:

        void error(int n, float val=0) const;

public:
        void report(ostream& strm=cout) const;
};


#endif
