/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __DEFS_H
#define __DEFS_H

#include <limits.h>
#include <float.h>

//invalid value for all state variables
#define NULL_TYPE UCHAR_MAX
#define NULL_INT INT_MIN
#define NULL_FLOAT FLT_MIN
#define NULL_LONG LONG_MIN
#define NULL_SHORT USHRT_MAX
#define NULL_DOUBLE DBL_MIN

//sort status for DistanceList
enum sort_types { UNSORTED, ASCENDING, DESCENDING };

enum variable_types { PREDICTOR, RESPONSE };
enum sample_types { INSIDE, OUTSIDE };
enum plotset_types { NO_TYPE, PLOT_BUFFER, PLOT_PLOT };

//two types of plotsets, WITH_CONTEXT = two sets of variables 
//for each plot, on set of variables is related to the spatial context
//of the plots, e.g. the buffer surrounding a plot
//WITHOUT_CONTEXT = only one set of variables, which is related
//to the plot 
enum categories { WITH_CONTEXT, WITHOUT_CONTEXT };

#define NULL 0

//turn on/off logging
#define LOG_ERROR 1
#define LOG_DEBUG 1
#define LOG_INFO 1
#define LOG_FILE 1
//#define LOG_SCREEN 1

#define MAX_PLOTS 100000
#define MAX_CONSTRAINTS 1000
#define MAX_ORDER 5

//identificator names for the PlotSet Types
static const char* PS_PLOT_BUFFER = "Plot_Buffer";
static const char* PS_PLOT_PLOT_PREDICTOR = "Plot_Plot_Predictor";
static const char* PS_PLOT_PLOT_RESPONSE = "Plot_Plot_Response";

#endif