/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __CONTROLLER_H
#define __CONTROLLER_H

#include "statistics.h"
#include "defs.h"

class FocusRegistry;
class DistanceConstraint;
class Constraint;

class Controller
{
private:
	FocusRegistry*			registry;
	const char*				config_filename;			//name of the configuration file
	unsigned short			iterations;					//iterations per constraints
	bool					statistics;					//if true, do statistics, otherwise just sample
	bool					write_plots;				//if true, sampled plots are observed and written to file
	bool					functional_stability;		//flag for executing or ignoring functional stability test
	bool					zero_regression;			//flag for regression with zero's only
	bool					include_zero_regression;	//flag for reporting zero regression
	plotset_types			plotset_type;				//Plot_Plot or Plot_Buffer configuration type
	unsigned short			current_constraint_index;	//counter for the current constraint
	Constraint*				current_constraint;			//pointer to current constraint
	RegressionData*			current_regression;			//stores results of current regression
	AnovaData*				current_anova;				//stores results of current anova

	double*					current_predictor_values;	
	double*					current_response_values;
	int						number_of_current_selected_plots;
	unsigned short			current_max_order;			//stores max order of the current fs test
	unsigned short			fs_order;					//max order for the functional stability test
	unsigned short			fs_percentage;				//percentage of iterations included in the functional stability test
	unsigned short			current_predictor_index;	//index for current predictor variable for selected plot

public:
	Controller(FocusRegistry* _registry, const char* _config_filename);
	~Controller() {};

	void execute();

	void setIterations(unsigned short _iterations)		{ iterations = _iterations; };
	unsigned short getIterations() const				{ return iterations; }

	AnovaData* getAnovaData() const						{ return current_anova; };
	RegressionData* getRegressionData() const			{ return current_regression; };
	Constraint* getConstraint() const					{ return current_constraint; };
	unsigned short getMaxOrder() const					{ return current_max_order; };
	unsigned short getConstraintIndex() const			{ return current_constraint_index; };
	unsigned short getPredictorIndex() const			{ return current_predictor_index; };
	plotset_types getPlotSetType() const				{ return plotset_type; };

	bool getStatistics() const							{ return statistics; };

	double* getCurrentPredictorValues() const			{ return current_predictor_values; };
	double* getCurrentResponseValues() const			{ return current_response_values; };
	int getNumberOfCurrentSelectedPlots() const			{ return number_of_current_selected_plots; };

private:
	void init();
	void observe(int _run);
	void sampleByDistance(DistanceConstraint* _constraint);
	void regression();
	void anova();
	void calc_aggr_stats();
	void functional_stability_test();
	void write_raw_stats(int _run);
	void write_aggr_stats();
	void write_plot_data();
	void resetCurrentData();
	void reset_observers();
	void set_current_variable_values();
	void closeOutputStreams();
	void writeOutputFileNames();
};

#endif