/*FOCUS-2.0 is a sampling and statistical data analysis program
for spatial data sets. Copyright (C) 2003  Lutz Tischendorf

This program is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.*/

#ifndef __CONTEXT_H
#define __CONTEXT_H

#include "defs.h"
#include "logging.h"
#include <iostream>
#include <vector>
#include <functional>

class FocusRegistry;

#if !defined (STLPORT) || defined(_STLP_USE_NAMESPACES)
using namespace std;
#endif

class SpatialContext
{
protected:
	const char*		name;			//name of the constraint, e.g. buffer width
	const char*		class_name;		//name of the class, e.g. BufferConstraint

public:
	SpatialContext(const char* _name, const char* _class_name);
	~SpatialContext();

	virtual bool operator==(const SpatialContext& _context) const;
	bool operator!=(const SpatialContext& _context) const;
	virtual bool operator <(const SpatialContext& _context) const;

	void setName(const char* _name)				{ name = _name; };
	const char* getName() const					{ return name; };

	const char* getClass_name() const			{ return class_name; };

	virtual void report(ostream& strm=cout) const;
};

class CircularPlotBuffer : public SpatialContext
{
private:
	double distance;

public:
	CircularPlotBuffer(const char* _name);
	CircularPlotBuffer(const char* _name, double _distance);
	~CircularPlotBuffer();

	bool operator==(const CircularPlotBuffer& _buffer) const;
	bool operator <(const CircularPlotBuffer& _buffer) const;

	void setDistance(double _distance)		{ distance = _distance; };
	double getDistance() const				{ return distance; };

	void report(ostream& strm=cout) const;
};

class SpatialContextList : public vector<SpatialContext*>
{
private:
	sort_types		sort_status;
	FocusRegistry*	registry;

public:
	SpatialContextList(FocusRegistry* _registry);
	~SpatialContextList();
	
	void addSpatialContext(SpatialContext* _context);
	void sortAscending();
	void sortDescending();

	sort_types getSort_status() const				{ return sort_status; };

	void report(ostream& strm=cout) const;
};

class Less_SpatialContext : public binary_function<SpatialContext*, SpatialContext*, bool> 
{
public:
	bool operator()(SpatialContext* _x, SpatialContext* _y) 
	{ 
		if(_x && !strcmp(_x->getClass_name(),"CircularPlotBuffer") &&
		   _y && !strcmp(_y->getClass_name(),"CircularPlotBuffer"))
			return (*((CircularPlotBuffer*)_x)) < (*((CircularPlotBuffer*)_y)); 
		else
		{
			Logging::log_error("Less_SpatialContext() type mismatch. Cannot compare ",
				               "different object types of SpatialContext!",NULL);
			return true;
		}
	}
};

class Greater_SpatialContext : public binary_function<SpatialContext*, SpatialContext*, bool> 
{
public:
	bool operator()(SpatialContext* _x, SpatialContext* _y) 
	{ 
		return !((*_x) < (*_y)); 
	}
};


#endif